function h = Histograma(N, distribucion)
    %Muestra el histograma a partir del nmero de datos y de la
    %distribucin de los mismos. Las distribuciones contempladas son
    %'normal', 'chi2', 'fschnedecor' y'normal2'
    
    if isequal(distribucion, 'normal') 
        for i = 1:100000,
          m(i) = mean(rand(1,N));
        end
        h = m/N;
        hist(h)
    elseif isequal(distribucion, 'chi2') 
        for i = 1:100000,
          m(i) = mean(chi2rnd(1,1,N));
        end
        h = m/N;
        hist(h)
    elseif isequal(distribucion, 'fschnedecor') 
        for i = 1:100000,
          m(i) = mean(frnd(1,2,1,N));
        end
        h = m/N;
        hist(h)
    elseif isequal(distribucion, 'normal2') 
        for i = 1:100000,
          m(i) = mean(rand(1,N).^2);
        end
        h = m/N;
        hist(h)
    else
        disp('ERROR. Distribucin no contemplada')
    end