function e = ClasifMinimaDist(x, y, dist)

    xtrn = x(1:1600);       ytrn = y(1:1600);
    xtst = x(1601:end);     ytst = y(1601:end);

    m0 = meanpat(myclass(xtrn,ytrn,0)); %centro de la clase 0
    m1 = meanpat(myclass(xtrn,ytrn,1)); %centro de la clase 1
    
    if isequal(dist, 'euclidea')
        d0 = sum(d_euclid(xtst,m0)); % distancia al centro de la clase 0 
        d1 = sum(d_euclid(xtst,m1)); % distancia al centro de la clase 1
    elseif isequal(dist, 'mahalanobis')
        c0 = covpat(myclass(xtrn,ytrn,0)); %Covarianza clase 0
		c1 = covpat(myclass(xtrn,ytrn,1)); %Covarianza clase 1
        d0 = d_mahal(xtst,m0,c0);          % distancia al centro de la clase 0   
		d1 = d_mahal(xtst,m1,c1);          % distancia al centro de la clase 1 
    end
    [a,b] = min([d0; d1]); %posiciones de las distancias mnimas (1, 2)
    clases = b - 1;        %clase que clasificamos los patrones 

    e = 100*length(find(clases~=ytst))/length(ytst); %error de clasificacin