function [x1, x2] = Frontera(w1, w2, pw1, L1, N)
    %Calcula lafrontera de decisin incluyendo el riesgo de prediccin
    
    pw2 = 1 - pw1;  
    L2 = 1 - L1;
    
    x = [w1 w2];
    y = [ones(1,N*pw1) 2*ones(1,N*pw2)];
    [x,y]=shuffle(x,y);

    indices1=find(y==1);  indices2=find(y==2);
    m1=mean(x(indices1)); m2=mean(x(indices2));
    s1=std(x(indices1));  s2=std(x(indices2));
    Pw1=length(indices1)/length(y);
    Pw2=length(indices2)/length(y);

    A=s1*s1-s2*s2;
    B=2*(m1*s2*s2-m2*s1*s1);
    C=2*s1*s1*s2*s2*(log(Pw1)-log(Pw2)+log(L1)-log(L2)-log(s1)+log(s2))+s1*s1*m2*m2-s2*s2*m1*m1;
    x1=(-B+sqrt(B*B-4*A*C))/2/A;
    x2=(-B-sqrt(B*B-4*A*C))/2/A;

    I = min([min(w1) min(w2)]):0.01: max([max(w1) max(w2)]);
    plot(I,Pw1*L1*normpdf(I,m1,s1));hold on;
    plot(I,Pw2*L2*normpdf(I,m2,s2),'r');hold off;