#include "cabecera.h"

char* LeerCadena()
{
	char *nom; 
    int i = 0;
    
    nom = (char*)malloc(sizeof(char));
    i = 0;
    while((nom[i]=getchar()) != '\n')
    {
        i++;            
        nom = (char*)realloc(nom, (i+1)*sizeof(char));
    }   
    nom[i] = '\0';    
    
    return nom; 
}

FILE* AbrirFicheroContrincante()
{
	FILE *fp;
	char *nom_fich;
	
	printf("\tIntroduzca el nombre del fichero con su jugada: ");	 
	fflush(stdin);
	nom_fich = LeerCadena();

	fp = fopen(nom_fich, "r");
    if(fp == NULL)
    {
      printf("\tError al abrir el fichero %s\n", nom_fich);
      system("pause");
      exit(1);
    }
    
    return fp;
}

char** InicializarMemoria()
{
   char** M;
   int i;
   
   M = (char**)malloc(F*sizeof(char*));
   for(i=0;i<C;i++)
     M[i] = (char*)malloc(C*sizeof(char));
     
   return M;
}

int Menu()
{
	int op;
	
	printf("\t1. Exportar fichero para jugar con otro PC\n");
	printf("\t2. Jugar contra la maquina\n");
	printf("\t3. Salir\n");
	printf("\tSu opcion: ");
	scanf("%d", &op);
	
	return op;	
}

void CargarJugadaUsuario(FILE *fp, char **matriz)
{
   int i = 0, j = 0;
   char c;
   
   while(!feof(fp))
   {
     c = fgetc(fp);
     if(c == '\n')
     {
        i++;
        j = 0;
     }
     else
     {
        matriz[i][j] = c;
        j++;
     }      
   }
}
void MatrizAgua(char **matriz)
{
  int i,j;
  
  for(i = 0; i < F; i++)
   {
       for(j = 0; j < C; j++)
          matriz[i][j] = 'a';       
   }	
}

int Barco2(char **matriz, int x, int y)
{
	int ok = 1;
	
	if(matriz[x+1][y] == 'a')
	  matriz[x+1][y] = 'B';
	else
	{
		if(matriz[x-1][y] == 'a')
		   matriz[x-1][y] = 'B';
		else
		{
			if(matriz[x][y+1] == 'a')
			   matriz[x][y+1] = 'B';
			else
			{
				if(matriz[x][y-1] == 'a')
				  matriz[x][y-1] = 'B';
				else
				  ok = 0; 
			}
		}
	}
	
	return ok;
}

int Barco3(char **matriz, int x, int y)
{
	int ok = 1;
	
	if(matriz[x+1][y] == 'a' && matriz[x+2][y] == 'a')
	{
	  matriz[x+1][y] = 'B';
	  matriz[x+2][y] = 'B';
    }
	else
	{
		if(matriz[x-1][y] == 'a' && matriz[x-2][y] == 'a')
		{
		   matriz[x-1][y] = 'B';
		   matriz[x-2][y] = 'B';
	    }
		else
		{
			if(matriz[x][y+1] == 'a' && matriz[x][y+2] == 'a')
			{
			   matriz[x][y+1] = 'B';
			   matriz[x][y+2] = 'B';
			}
			else
			{
				if(matriz[x][y-1] == 'a' && matriz[x][y-2] == 'a')
				{
				  matriz[x][y-1] = 'B';
				  matriz[x][y-2] = 'B';
				}
				else
				  ok = 0; 
			}
		}
	}
	
	return ok;
}

void GeneraBarco(char **matriz, int lon)
{
   int salir = 0, i, j, a, b;
   
   a = F - 6; //Intervalo (a,b) donde se van a generar los nmeros aleatorios
   b = F - 3;
   
   while(!salir)
   {
	   i = a + (b - a) * ((rand()%101)/100.0);	  	
	   j = a + (b - a) * ((rand()%101)/100.0);
	   if(matriz[i][j] == 'a')
	   {	   
	      matriz[i][j] = 'B';
	      switch(lon)
	      {
			case 2:salir = Barco2(matriz, i, j);
				   break;
			case 3:salir = Barco3(matriz, i, j);
				   break;
		  }
	   }  
   }
}

void ExportarFichero(char **matriz)
{
	FILE *fPC;
	int i,j;
	
	fPC = fopen("JugadaPC.txt", "w");
	if(!fPC)
	{
		printf("\tERROR al abrir el fichero JugadaPC.txt\n");
		system("pause");
		exit(1);		
	}
	
	for(i = 0; i < F; i++)
	{
		for(j = 0; j < C; j++)
		   fprintf(fPC, "%c ", matriz[i][j]);
        fprintf(fPC,"\n");
	}
	
	fclose(fPC);
}

void GenerarJugadaPC(char **matriz)
{
   MatrizAgua(matriz);
   GeneraBarco(matriz,2);
   GeneraBarco(matriz,3);
   GeneraBarco(matriz,3);
   ExportarFichero(matriz); 
}

void Inicializar(char **matriz)
{
   int i, j;
   
   for(i = 0; i < F; i++)
   {
      for(j = 0; j < C; j++)
         matriz[i][j] = '-';
   }
}
int Hundido2(char **matriz, int x, int y)
{
	int ok = 0;
	
	if(matriz[x+1][y] == 'X' || matriz[x-1][y] == 'X' || matriz[x][y+1] == 'X' || matriz[x][y-1] == 'X')
	  ok = 1;
		
	return ok;
}

int Hundido3(char **matriz, int x, int y)
{
	int ok = 0;
	
	if((matriz[x+1][y] == 'X' && matriz[x+2][y] == 'X') || (matriz[x-1][y] == 'X' && matriz[x-2][y] == 'X') || (matriz[x][y+1] == 'X' && matriz[x][y+2] == 'X') || (matriz[x][y-1] == 'X' && matriz[x][y-2] == 'X'))
	  ok = 1;
	
	return ok;
}

int Hundido(char **matriz, int x, int y)
{
   int ok = 0;
   
   if(Hundido3(matriz, x, y) || Hundido2(matriz, x, y))
      ok = 1;
      
   return ok;	
}

void ComprobarBomba(char **matriz, char **tiradas, int x, int y)
{
	if(matriz[x][y] == 'a')
    {
	 tiradas[x][y] = 'a'; 	
     printf("\n\tAGUA!!!!\n");
    }
    else
    {
     matriz[x][y] = 'X';
     tiradas[x][y] = 'B';
     if(Hundido(matriz, x, y))
        printf("\n\tTOCADO Y HUNDIDO!!!!");
     else
        printf("\n\tTOCADO!!!\n"); 
   }  
}

void JuegaUsuario(char **matriz, char **tiradas)
{
   int f, c;
   
   do{
  	printf("\tIntroduzca una coordenada: ");
    scanf("%d %d", &f, &c);
   }while(tiradas[f][c] != '-');
   
   ComprobarBomba(matriz, tiradas, f, c); 
}

void MostrarSituacion(char **matriz)
{
   int i, j;
   
   printf("\t");
   for(i = 0; i < F; i++)
   {
       for(j = 0; j < C; j++)
          printf("%c ", matriz[i][j]);
       printf("\n\t");       
   }     
}

int GanaJuego(char **matriz)
{
   int i = 0, j = 0, salir = 0;
   
   while(i < F && !salir)
   {
      j = 0;                
      while(j < C && !salir)
      {
         if(matriz[i][j] == 'B')
            salir = 1;
         j++;
      }
      i++;
   }    
   return !salir;
}

void JuegaPC(char **matriz, char** tiradas)
{
  int i, j;
  
  do{
  	i = (rand() % F);  //Numeros entre 0 y F
  	j = (rand() % C);  //Numeros entre 0 y C
  }while(tiradas[i][j] != '-');
  
  printf("\tLa coordenanda del PC es: %d %d\n", i, j);
  
  ComprobarBomba(matriz, tiradas, i, j);      
}

void JugarBarquitos()
{
	 char c, **tablero_usu, **tablero_pc, **tiradas_usu, **tiradas_pc;
	 FILE *fp;
	 int gana, turno;	
	
	 tablero_pc = InicializarMemoria();
	 tablero_usu = InicializarMemoria();	
	 tiradas_usu = InicializarMemoria();
	 tiradas_pc = InicializarMemoria();
	 
	 fflush(stdin);
	 printf("\n\tDesea comenzar (s/n)? ");
	 scanf("%c", &c);
	 
	 while(c != 'n')
	 { 
		fp = AbrirFicheroContrincante();
		CargarJugadaUsuario(fp, tablero_usu);
		GenerarJugadaPC(tablero_pc);
	    MostrarSituacion(tablero_pc);
	    gana = 0;
	    turno = 1; //1 -> Usuario, 2-> PC
	    Inicializar(tiradas_usu);
	    Inicializar(tiradas_pc);
	    while(!gana)
	    {
	       if(turno == 1) //Juega el usuario
	       {
	          printf("Juega el usuario\n");
	          JuegaUsuario(tablero_pc, tiradas_usu);
	          printf("\n\tSus tiradas\n");
	          MostrarSituacion(tiradas_usu); 
	          gana = GanaJuego(tablero_pc);
	          if(gana)
	            printf("\tEnhorabuena!!!! Usted gana %c\n", 2);
	          turno = 2; 
	       }
	       else
	       {
	          printf("\nJuega el PC\n"); 
	          JuegaPC(tablero_usu, tiradas_pc); 
	          printf("\n\tSu situacion\n");
	          MostrarSituacion(tablero_usu); 
	          gana = GanaJuego(tablero_usu);
	          if(gana)
	            printf("\tLo siento!!!! Gana el ordenador :(\n");
	          turno = 1;
	       }
	    }
	    fclose(fp);
	    printf("\tQuiere jugar de nuevo (s/n)? ");
	    fflush(stdin);
	    scanf("%c", &c);
	}
}

