//
//  funciones.c
//  T5_Ej4
//
//  Created by Mari Paz Guerrero Lebrero on 7/5/15.
//  Copyright (c) 2015 Mari Paz Guerrero Lebrero. All rights reserved.
//

#include "cabeceras.h"

char** Inicializar()
{
    char **M;
    int i, j;
    
    M = (char**)malloc(F*sizeof(char*));
    
    for(i = 0; i < F; i++)
    {
        M[i] = (char*)malloc(C*sizeof(char));
        for(j = 0; j < C; j++)
            M[i][j] = '-';
    }
    
    return M;
}

void MostrarSituacion(char **matriz)
{
    int i, j;
    
    for(i = 0; i < F; i++)
    {
        for(j = 0; j < C; j++)
            printf("%c ", matriz[i][j]);
        printf("\n");
    }
}

void JuegaUsuario(char **matriz)
{
    int i, j, salir = 0;
    
    printf("Introduzca una coordenada: ");
    scanf("%d %d", &i, &j);
    
    while(!salir)
    {
        if(matriz[i][j] == '-')
        {
            matriz[i][j] = 'o';
            salir = 1;
        }
        else
        {
            printf("\nPosicion ocupada, introduzca una nueva coordenada: ");
            scanf("%d %d", &i, &j);
        }
    }
}

int GanaJuego(char **matriz, char c)
{
    int i = 0, salir = 0;
    
    while(i < F && !salir)
    {
        if(matriz[i][0] == c && matriz[i][1] == c && matriz[i][2] == c)
            salir = 1;
        else
        {
            if(matriz[0][i] == c && matriz[1][i] == c && matriz[2][i] == c)
                salir = 1;
        }
        i++;
    }
    if(!salir) //Miro las diagonales
    {
        if(matriz[0][0] == c && matriz[1][1] == c && matriz[2][2] == c)
            salir = 1;
        else
        {
            if(matriz[0][2] == c && matriz[1][1] == c && matriz[2][0] == c)
                salir = 1;
        }
    }
    return salir;
}

void JuegaPC(char **matriz)
{
    int i, j, salir = 0;
    
    srand(time(NULL));  //Semilla aleatoria
    i = (rand() % 3);  //Numeros entre 0 y 2
    j = (rand() % 3);  //Numeros entre 0 y 2
    
    while(!salir)
    {
        if(matriz[i][j] == '-')
        {
            printf("Coordenada del PC: %d %d\n", i, j);
            matriz[i][j] = 'x';
            salir = 1;
        }
        else
        {
            i = (rand() % 3);  //Numeros entre 0 y 2
            j = (rand() % 3);  //Numeros entre 0 y 2
        }
    }
}
