/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Objects;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientResponse;

class InboundJaxrsResponse
extends Response {
    private final ClientResponse context;

    public InboundJaxrsResponse(ClientResponse context) {
        this.context = context;
    }

    public int getStatus() {
        return this.context.getStatus();
    }

    public Response.StatusType getStatusInfo() {
        return this.context.getStatusInfo();
    }

    public Object getEntity() throws IllegalStateException {
        return this.context.getEntityStream();
    }

    public <T> T readEntity(Class<T> entityType) throws ProcessingException, IllegalStateException {
        return (T)this.context.readEntity(entityType, this.context.getRequestContext().getPropertiesDelegate());
    }

    public <T> T readEntity(GenericType<T> entityType) throws ProcessingException, IllegalStateException {
        return (T)this.context.readEntity(entityType.getRawType(), entityType.getType(), this.context.getRequestContext().getPropertiesDelegate());
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) throws ProcessingException, IllegalStateException {
        return (T)this.context.readEntity(entityType, annotations, this.context.getRequestContext().getPropertiesDelegate());
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) throws ProcessingException, IllegalStateException {
        return (T)this.context.readEntity(entityType.getRawType(), entityType.getType(), annotations, this.context.getRequestContext().getPropertiesDelegate());
    }

    public boolean hasEntity() {
        return this.context.hasEntity();
    }

    public boolean bufferEntity() throws ProcessingException {
        return this.context.bufferEntity();
    }

    public void close() throws ProcessingException {
        this.context.close();
    }

    public String getHeaderString(String name) {
        return this.context.getHeaderString(name);
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.context.getHeaders();
    }

    public MediaType getMediaType() {
        return this.context.getMediaType();
    }

    public Locale getLanguage() {
        return this.context.getLanguage();
    }

    public int getLength() {
        return this.context.getLength();
    }

    public Map<String, NewCookie> getCookies() {
        return this.context.getResponseCookies();
    }

    public EntityTag getEntityTag() {
        return this.context.getEntityTag();
    }

    public Date getDate() {
        return this.context.getDate();
    }

    public Date getLastModified() {
        return this.context.getLastModified();
    }

    public Set<String> getAllowedMethods() {
        return this.context.getAllowedMethods();
    }

    public URI getLocation() {
        return this.context.getLocation();
    }

    public Set<Link> getLinks() {
        return this.context.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.context.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.context.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.context.getLinkBuilder(relation);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        MultivaluedMap headers = this.context.getHeaders();
        return headers;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).addValue((Object)this.context).toString();
    }
}

