/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
class DelegatedInjectionValueFactoryProvider
implements ValueFactoryProvider {
    private final ContextInjectionResolver resolver;
    private static final Map<Class<?>, ActiveDescriptor> PROXIABLE_TYPE_DESC = Collections.unmodifiableMap(new HashMap<Class<?>, ActiveDescriptor>(){
        {
            this.put(UriInfo.class, DelegatedInjectionValueFactoryProvider.createDescriptor(UriInfo.class));
            this.put(HttpHeaders.class, DelegatedInjectionValueFactoryProvider.createDescriptor(HttpHeaders.class));
            this.put(Request.class, DelegatedInjectionValueFactoryProvider.createDescriptor(Request.class));
            this.put(SecurityContext.class, DelegatedInjectionValueFactoryProvider.createDescriptor(SecurityContext.class));
        }
    });

    @Inject
    public DelegatedInjectionValueFactoryProvider(ServiceLocator locator) {
        ContextInjectionResolver result = null;
        for (InjectionResolver r : Providers.getProviders((ServiceLocator)locator, InjectionResolver.class)) {
            if (!ContextInjectionResolver.class.isInstance(r)) continue;
            result = (ContextInjectionResolver)ContextInjectionResolver.class.cast(r);
            break;
        }
        this.resolver = result;
    }

    @Override
    public Factory<?> getValueFactory(Parameter parameter) {
        Parameter.Source paramSource = parameter.getSource();
        if (paramSource == Parameter.Source.CONTEXT) {
            final Injectee effectiveInjectee = DelegatedInjectionValueFactoryProvider.getInjectee(parameter);
            return new Factory<Object>(){

                public Object provide() {
                    return DelegatedInjectionValueFactoryProvider.this.resolver.resolve(effectiveInjectee, null);
                }

                public void dispose(Object instance) {
                }
            };
        }
        return null;
    }

    @Override
    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.LOW;
    }

    private static Injectee getInjectee(final Parameter parameter) {
        return new InjecteeImpl(){
            private Class<?> rawType;
            {
                this.rawType = parameter.getRawType();
                this.setRequiredType(parameter.getType());
                this.setRequiredQualifiers(Collections.emptySet());
                ActiveDescriptor proxyDescriptor = (ActiveDescriptor)PROXIABLE_TYPE_DESC.get(this.rawType);
                if (proxyDescriptor != null) {
                    this.setInjecteeDescriptor(proxyDescriptor);
                }
            }

            public Class<?> getInjecteeClass() {
                return this.rawType;
            }
        };
    }

    private static <T> AbstractActiveDescriptor<T> createDescriptor(final Class<T> clazz) {
        return new AbstractActiveDescriptor<T>(){

            public Class<T> getImplementationClass() {
                return clazz;
            }

            public Object create(ServiceHandle sh) {
                return null;
            }

            public Boolean isProxyForSameScope() {
                return false;
            }

            public synchronized String getScope() {
                return RequestScoped.class.getName();
            }
        };
    }
}

