/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.security.Principal;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.LocalizationMessages;

public class SecurityContextInjectee
implements SecurityContext {
    private ContainerRequestContext requestContext;

    public void setRequest(ContainerRequestContext containerRequest) {
        if (this.requestContext != null) {
            throw new IllegalStateException(LocalizationMessages.SECURITY_CONTEXT_WAS_ALREADY_SET());
        }
        this.requestContext = containerRequest;
    }

    public Principal getUserPrincipal() {
        this.checkState();
        return this.requestContext.getSecurityContext().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        this.checkState();
        return this.requestContext.getSecurityContext().isUserInRole(role);
    }

    public boolean isSecure() {
        this.checkState();
        return this.requestContext.getSecurityContext().isSecure();
    }

    public String getAuthenticationScheme() {
        this.checkState();
        return this.requestContext.getSecurityContext().getAuthenticationScheme();
    }

    public int hashCode() {
        this.checkState();
        return 7 * this.requestContext.getSecurityContext().hashCode();
    }

    public boolean equals(Object that) {
        this.checkState();
        if (!(that instanceof SecurityContext)) {
            return false;
        }
        return that.equals(this.requestContext.getSecurityContext());
    }

    private void checkState() {
        if (this.requestContext == null) {
            throw new IllegalStateException(LocalizationMessages.SECURITY_CONTEXT_WAS_NOT_SET());
        }
    }
}

