/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SystemDescriptor;

@Singleton
public class SingletonContext
implements Context<Singleton> {
    private int generationNumber = Integer.MIN_VALUE;
    private final ServiceLocatorImpl locator;
    private final HashMap<ActiveDescriptor<?>, Long> creatingDescriptors = new HashMap();

    SingletonContext(ServiceLocatorImpl impl) {
        this.locator = impl;
    }

    public Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T findOrCreate(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) {
        Object retVal;
        SingletonContext singletonContext = this;
        synchronized (singletonContext) {
            retVal = activeDescriptor.getCache();
            if (retVal != null) {
                return (T)retVal;
            }
            while (this.creatingDescriptors.containsKey(activeDescriptor)) {
                long creatingThreadId = this.creatingDescriptors.get(activeDescriptor);
                if (creatingThreadId == Thread.currentThread().getId()) {
                    throw new MultiException((Throwable)new IllegalStateException("A circular dependency involving Singleton service " + activeDescriptor.getImplementation() + " was found.  Full descriptor is " + activeDescriptor));
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            retVal = activeDescriptor.getCache();
            if (retVal != null) {
                return (T)retVal;
            }
            this.creatingDescriptors.put(activeDescriptor, Thread.currentThread().getId());
        }
        try {
            retVal = activeDescriptor.create(root);
        }
        finally {
            singletonContext = this;
            synchronized (singletonContext) {
                if (retVal != null) {
                    activeDescriptor.setCache(retVal);
                    if (activeDescriptor instanceof SystemDescriptor) {
                        ((SystemDescriptor)activeDescriptor).setSingletonGeneration(this.generationNumber++);
                    }
                }
                this.creatingDescriptors.remove(activeDescriptor);
                this.notifyAll();
            }
        }
        return (T)retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        SingletonContext singletonContext = this;
        synchronized (singletonContext) {
            return descriptor.getCache() != null;
        }
    }

    public boolean isActive() {
        return true;
    }

    public boolean supportsNullCreation() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<ActiveDescriptor<?>> all = this.locator.getDescriptors(BuilderHelper.allFilter());
        long myLocatorId = this.locator.getLocatorId();
        TreeSet<SystemDescriptor<Object>> singlesOnly = new TreeSet<SystemDescriptor<Object>>(new GenerationComparator());
        for (ActiveDescriptor<?> activeDescriptor : all) {
            if (activeDescriptor.getScope() == null || !activeDescriptor.getScope().equals(Singleton.class.getName())) continue;
            SingletonContext singletonContext = this;
            synchronized (singletonContext) {
                if (activeDescriptor.getCache() == null) {
                    continue;
                }
            }
            if (activeDescriptor.getLocatorId() == null || activeDescriptor.getLocatorId() != myLocatorId) continue;
            SystemDescriptor oneAsObject = (SystemDescriptor)activeDescriptor;
            singlesOnly.add(oneAsObject);
        }
        for (SystemDescriptor systemDescriptor : singlesOnly) {
            this.destroyOne(systemDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyOne(ActiveDescriptor<?> one) {
        Object value;
        SingletonContext singletonContext = this;
        synchronized (singletonContext) {
            value = one.getCache();
            one.releaseCache();
            if (value == null) {
                return;
            }
        }
        try {
            one.dispose(value);
        }
        catch (Throwable th) {
            Logger.getLogger().debug("SingletonContext", "releaseOne", th);
        }
    }

    private static class GenerationComparator
    implements Comparator<SystemDescriptor<Object>>,
    Serializable {
        private static final long serialVersionUID = -6931828935035131179L;

        private GenerationComparator() {
        }

        @Override
        public int compare(SystemDescriptor<Object> o1, SystemDescriptor<Object> o2) {
            if (o1.getSingletonGeneration() > o2.getSingletonGeneration()) {
                return -1;
            }
            if (o1.getSingletonGeneration() == o2.getSingletonGeneration()) {
                return 0;
            }
            return 1;
        }
    }
}

